%------------------------------------------------------------------------------
% File     : CSR153^1 : TPTP v4.1.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Is there a common relation?
% Version  : Especial.
% English  : Mary, Sue, Bill and Bob are mutually distinct. Mary is neither a
%            sister of Sue nor of Bill. Bob is not a brother of Mary. Sue is a
%            sister of Bill and of Bob. Bob is a brother of Bill. Is there a 
%            relation that holds both between Bob and Bill and between Sue and 
%            Bob?

% Refs     : [PS07]  Pease & Sutcliffe (2007), First Order Reasoning on a L
%          : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : paar_9.tq_SUMO_local [Ben10]

% Status   : Theorem
% Rating   : 0.60 v4.1.0
% Syntax   : Number of formulae    :   13 (   5 unit;   7 type;   0 defn)
%            Number of atoms       :   66 (   6 equality;   5 variable)
%            Maximal formula depth :    9 (   4 average)
%            Number of connectives :   37 (   0   ~;   0   |;   9   &;  28   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&;   0  !!;   0  ??)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   11 (   7   :)
%            Number of variables   :    3 (   0 sgn;   2   !;   1   ?;   0   ^)
%                                         (   3   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : THF_THM_EQU

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2THF translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted Signature
thf(numbers,type,(
    num: $tType )).

thf(brother_THFTYPE_IiioI,type,(
    brother_THFTYPE_IiioI: $i > $i > $o )).

thf(lBill_THFTYPE_i,type,(
    lBill_THFTYPE_i: $i )).

thf(lBob_THFTYPE_i,type,(
    lBob_THFTYPE_i: $i )).

thf(lMary_THFTYPE_i,type,(
    lMary_THFTYPE_i: $i )).

thf(lSue_THFTYPE_i,type,(
    lSue_THFTYPE_i: $i )).

thf(sister_THFTYPE_IiioI,type,(
    sister_THFTYPE_IiioI: $i > $i > $o )).

%----The translated axioms
thf(ax,axiom,
    ( ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i )
    & ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
    & ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lBill_THFTYPE_i ) )).

thf(ax_001,axiom,
    ( ( ~ @ ( lMary_THFTYPE_i = lSue_THFTYPE_i ) )
    & ( ~ @ ( lMary_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( ~ @ ( lBob_THFTYPE_i = lMary_THFTYPE_i ) ) )).

thf(ax_002,axiom,
    ( ( ~ @ ( lSue_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( ~ @ ( lSue_THFTYPE_i = lBob_THFTYPE_i ) ) )).

thf(ax_003,axiom,
    ( ( ~ @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lSue_THFTYPE_i ) )
    & ( ~ @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ) )
    & ( ~ @ ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lMary_THFTYPE_i ) ) )).

thf(ax_004,axiom,
    ( ~ @ ( lBob_THFTYPE_i = lBill_THFTYPE_i ) )).

%----The translated conjectures
thf(con,conjecture,(
    ? [R: $i > $i > $o] :
      ( ( R @ lBob_THFTYPE_i @ lBill_THFTYPE_i )
      & ( R @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
      & ( ~
        @ ! [X: $i,Y: $i] :
            ( R @ X @ Y ) ) ) )).

%------------------------------------------------------------------------------
